<?xml version="1.0" encoding="UTF-8"?>
<xsl:transform version="1.0" 
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:fn="http://www.w3.org/2005/xpath-functions"
		xmlns:mx="http://www.mobotix.com/xslfuncs">
		
<!--
		Generic Table Template

-->
		
<xsl:template name="generic-table">
	<xsl:param name="table"/>
	
<table cellspacing="0" cellpadding="4" style="border-style:solid;" border="1">
<thead>
 <tr>
 	<xsl:for-each select="$table/table-header/th">
		<th>
			<xsl:value-of select="."/>
		</th>
 	</xsl:for-each>
 </tr>
</thead>

<xsl:for-each select="$table/tr">
	<tr>
		<xsl:attribute name="bgcolor">
			<xsl:choose>
				<xsl:when test="(position() mod 2)=0">#eeeeee</xsl:when>
				<xsl:otherwise>white</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
		
		<xsl:for-each select="td">
			<td nowrap="1">
				<xsl:value-of select="."/>
				<xsl:if test="@icon">
					<img border="0" align="right">
						<xsl:attribute name="source"><xsl:value-of select="@icon"/></xsl:attribute>
						<!-- Qt bug: "src" ignores white space in path names, "source" works better !! -->
						<xsl:attribute name="src"><xsl:value-of select="@icon"/></xsl:attribute>
						<xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute>
						<xsl:attribute name="height"><xsl:value-of select="@height"/></xsl:attribute>
					</img>
				</xsl:if>				
			</td>
		</xsl:for-each>
	</tr>
</xsl:for-each>

</table>
		
</xsl:template>

</xsl:transform>